using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Business;
using System.Collections.Generic;


namespace StrataFlix.Reporting
{
	namespace Reports
	{
		namespace PeopleProfileReport
		{
			
			
			public class MovieCastBO : StrataFlix.Business.MovieCastBO
			{
				
				
				#region " Private Fields "
				
				private static bool _AreCustomDescriptorsEvaluated = false;
				
				#endregion
				
				#region " Protected Methods "
				
				/// <summary>
				/// Determine if the custom descriptors are going to be evaluated
				/// </summary>
				/// <remarks></remarks>
				protected override bool AreCustomDescriptorsEvaluated
				{
					get
					{
						//-- Establish Locals
						bool r = _AreCustomDescriptorsEvaluated;
						
						//-- Do not eval the desciptors again
						_AreCustomDescriptorsEvaluated = true;
						
						//-- Return results
						return r;
					}
				}
				
				/// <summary>
				/// Add additional binding fields
				/// </summary>
				/// <remarks></remarks>
				protected override MicroFour.StrataFrame.Business.FieldPropertyDescriptor[] GetCustomBindablePropertyDescriptors()
				{
					//-- Establish Locals
					List<FieldPropertyDescriptor> r = new List<FieldPropertyDescriptor>();
					
					//-- Include all of the base descriptors
					try
					{
						r.AddRange(base.GetCustomBindablePropertyDescriptors());
					}
					catch (Exception)
					{
					}
					
					//-- Add the custom descriptors
					r.Add(new ReflectionPropertyDescriptor("mv_Title", typeof(MovieCastBO)));
					r.Add(new ReflectionPropertyDescriptor("mv_Year", typeof(MovieCastBO)));
					
					//-- Return results
					return r.ToArray();
				}
				
				#endregion
				
				#region " Public Properties "
				
				/// <summary>
				/// The movie title
				/// </summary>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				public string mv_Title
				{
					get
					{
						return System.Convert.ToString(this.CurrentRow["mv_Title"]);
					}
				}
				
				/// <summary>
				/// The year the movie was made
				/// </summary>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				public string mv_Year
				{
					get
					{
						return System.Convert.ToString(this.CurrentRow["mv_Year"]);
					}
				}
				
				#endregion
				
			}
			
			
		}
	}
}
